from GamePlay import PYBaseGamePlay
import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

EP_SHOUT_COLOR = GEUtil.CColor(240,200,120,170)
FT_DEBUG = False

def ep_clamp(v, a, b):
	return ep_tf(a <= b, ep_greatest(a, ep_least(v, b)), ep_greatest(b, ep_least(v, a)))

def ep_greatest(a, b):
	if b >= a :
		return b
	return a

def ep_incrementscore(player, frags):
	GEMPGameRules.GetTeam(player.GetTeamNumber()).IncrementRoundScore(frags)
	player.IncrementScore(frags)
	return player

def ep_least(a, b):
	if a <= b :
		return a
	return b

def ep_naturalsubtraction(value, delta):
	if value > delta:
		return value - delta
	return 0

def ep_player_by_id(uid):
	return GEPlayer.ToMPPlayer(GEEntity.GetEntByUniqueId(uid))

def ep_plural(v, sing, plur):
	if v != 1 :
		return plur
	return sing

def ep_shout(msg):
	if FT_DEBUG :
		GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, msg)
		GEUtil.HudMessage(None,msg,-1,-1,EP_SHOUT_COLOR,2.0,0.25,2.75)
	return msg

def ep_tf(v, t, f):
	if v :
		return t
	return f

class LivingDaylightsFlag:
	LEVEL_LIMIT = 10
	ESCAPE_TIME = 80
	ESCAPE_AP_LIMIT = 40
	AGE_SCALE = 1.0
	BONUS_ITEM = [10, 15, 25, 35]
	BONUS_LIMIT = 4
	ADREN_MAX = 40

	def __init__(self):
		self.zot()

	def age(self, ticks, handled):
		if self.i_am_held():
			self.exp_to_next -= ticks * self.AGE_SCALE
			if handled and self.exp_to_next <= 0:
				if self.level < self.LEVEL_LIMIT:
					self.level += 1
				self.earnings += 1
				self.exp_to_next += self.exp_this_level(self.level)
				return True
		return False

	def age_escape(self, ticks):
		if self.exp_to_escape > -1 and self.i_am_held():
			self.adrenaline = ep_naturalsubtraction(self.adrenaline, ticks)
			self.exp_to_escape -= ticks
			if self.exp_to_escape <= 0:
				self.escapes += 1
				self.exp_to_escape = -1
				return True
		return False

	def age_item(self, itemindex, coeff):
		if itemindex >= 0 and itemindex < self.BONUS_LIMIT:
			self.age(self.BONUS_ITEM[itemindex] * coeff, False)

	def escape(self, force, inflicted_damage):
		if (force or self.exp_to_escape >= 0) and self.i_am_held():
			self.exp_to_escape = self.ESCAPE_TIME
			if force:
				ep_shout("Adrenaline trigger.")
				self.adrenaline = self.ADREN_MAX
				self.escape_ap = ep_least(self.ESCAPE_AP_LIMIT, self.escape_ap + inflicted_damage)
			else:
				ep_shout("No adrenaline.")

	def exp_this_level(self, req_level):
		return (ep_clamp(req_level, 1, self.LEVEL_LIMIT) + 2) * 10

	def i_am_held(self):
		if self.token_id != 0 and self.player_id != 0:
			player = ep_player_by_id(self.player_id)
			return player.GetTeamNumber() != GEGlobal.TEAM_SPECTATOR and player.IsAlive()
		return False

	def level_by_playercount(self, pc):
		self.level = ep_clamp(self.LEVEL_LIMIT + 1 - pc ,0, self.LEVEL_LIMIT)

	def release(self):
		self.player_previous = self.player_id
		self.earnings_total += self.earnings
		self.earnings_previous = self.earnings
		if GEMPGameRules.IsTeamplay():
			if self.player_id != 0:
				self.team_previous = ep_player_by_id(self.player_id).GetTeamNumber()
		self.player_id = 0
		self.earnings = 0
		self.earnings_total = 0
		self.escapes = 0
		self.escape_ap = 0
		self.exp_to_next = 0
		self.exp_to_escape = -1
		self.armor_up = -1
		self.adrenaline = 0

	def zot(self):
		# double zeroed because Python is lame.
		self.player_id = 0
		self.earnings = 0
		self.earnings_total = 0
		self.release()
		self.player_previous = self.player_id
		self.earnings_total += self.earnings
		self.earnings_previous = self.earnings
		self.team_previous = GEGlobal.TEAM_SPECTATOR
		self.level = 0
		self.token_id = 0

class TurboLD(PYBaseGamePlay):
	BAR_CARRY = 100
	BAR_ESCAPE = 100
	BAR_CAP_X = 0.3

	COLOR_COLD = GEUtil.CColor(30,150,180,170)
	COLOR_HOLD = GEUtil.CColor(255,180,225,170)
	COLOR_H_MI = GEUtil.CColor(180,225,255,170)
	COLOR_H_JS = GEUtil.CColor(255,225,180,170)
	COLOR_WARM = GEUtil.CColor(180,150,30,170)
	COLOR_CASH = GEUtil.CColor(240,225,45,170)

	PERK_ADREN = 0.3
	PERK_SPEED = 0.025

	THEFT_DELTA = 1

	# Flag information management
	FLAGLIST_LIMIT = 16
	FLAGLIST_MAXID = FLAGLIST_LIMIT - 1
	flaglist = [LivingDaylightsFlag() for j in range(FLAGLIST_LIMIT)]

	def ft_ageflag(self, flagindex, ticks):
		if self.flaglist[flagindex].age(ticks, True) :
				self.ft_creditcarrier(self.flaglist[flagindex])

	# Flag Tag functions
	def ft_ageflags(self):
		for j in range(self.FLAGLIST_LIMIT):
			flag = self.flaglist[j]
			if flag.exp_to_escape > -1:
				self.ft_perk_speed(j)
			if flag.age_escape(1) :
				self.ft_creditescape(flag)
			if flag.age(1, True) :
				self.ft_creditcarrier(flag, 1)
				self.ft_perk_speed(j)
			if flag.armor_up > -1:
				self.ft_escapee_armorapply(flag)

	def ft_announceearning(self, flag, frags):
		player = ep_player_by_id(flag.player_id)
	#	GEUtil.HudMessage(player, "You have earned %d point%s" % (flag.earnings, ep_plural(flag.earnings, ".", "s.")),-1,-1,EP_SHOUT_COLOR,2.0,0.25,2.75)
		GEUtil.PlaySoundToPlayer(player,"GEGamePlay.Token_Chime")
		self.ft_progressbar(flag, ep_player_by_id(flag.player_id))

	def ft_announceescaping(self, flag):
		player = ep_player_by_id(flag.player_id)
		GEUtil.HudMessage(player, "You have escaped combat %d time%s" % (flag.escapes, ep_plural(flag.escapes, ".", "s.")),-1,-1,EP_SHOUT_COLOR,2.0,0.25,2.75)
		GEUtil.PlaySoundToPlayer(player,"Buttons.beep_ok")
		ep_shout("Escaped successfully.")

	def ft_associate(self, token, player):
		flagindex = self.ft_flagindexbytoken(token)
		if( flagindex >= 0 ) :
			self.flaglist[flagindex].player_id = GEEntity.GetUniqueId(player)
			#self.ft_progressbar(self.flaglist[flagindex], player)
		else :
			ep_shout("[ft_associate] Token %d does not have associated information." % (GEEntity.GetUniqueId(token)) )
		return flagindex

	def ft_coldflaglevel(self, index):
		if( index >= 0 ):
			self.flaglist[index].level_by_playercount(GEMPGameRules.GetNumActivePlayers())

	def ft_creditcarrier(self, flag, frags):
		ep_incrementscore(ep_player_by_id(flag.player_id), frags)
		self.ft_announceearning(flag, frags)

	def ft_creditescape(self, flag):
		player = ep_player_by_id(flag.player_id)
		ep_incrementscore(player, flag.escapes)
		self.ft_escapee_armorup(flag, player)
		self.ft_announceescaping(flag)
		self.ft_escapebar_remove(flag)

	def ft_disassociate(self, token, respawned):
		flagindex = self.ft_flagindexbytoken(token)
		if( flagindex >= 0 ) :
			flag = self.flaglist[flagindex]
			self.ft_progressbar_remove(flag)
			self.ft_escapebar_remove(flag)
			if respawned:
				flag.zot()
			else:
				flag.release()
		else:
			ep_shout("[Disassociate] Token %d was unregistered when dropped.")
		return flagindex

	def ft_escapebar(self, flag, player):
		GEUtil.InitHudProgressBarPlayer(player, 1, "%d " % (flag.escapes + 1), 1, flag.ESCAPE_TIME, -1, .72, self.BAR_ESCAPE, 10, self.COLOR_WARM)
		#GEUtil.InitHudProgressBarPlayer(player, 1, ", 1, flag.ESCAPE_TIME, -1, .72, self.BAR_ESCAPE, 10, self.COLOR_WARM)
		#GEUtil.InitHudProgressBarPlayer(player, 3, "%d" % (flag.escapes + 1), 1, flag.ESCAPE_TIME, self.BAR_CAP_X, .72, self.BAR_ESCAPE, 10, self.COLOR_WARM)

	def ft_escapebar_remove(self, flag):
		GEUtil.RemoveHudProgressBarPlayer(ep_player_by_id(flag.player_id), 1)

	# Shitty hack around GUI failure.
	def ft_escapee_armorapply(self, flag):
		ep_player_by_id(flag.player_id).SetArmor(flag.armor_up)
		flag.armor_up = -1

	def ft_escapee_armorup(self, flag, player):
		newarmor = ep_clamp(int(player.GetArmor() + flag.escape_ap), 0, GEGlobal.GE_MAX_ARMOR)
		flag.escape_ap = 0;
		player.SetMaxArmor(newarmor)
		flag.armor_up = newarmor

	def ft_flagdebt(self):
		return self.ft_flagsdesired() - self.ft_flagsregistered()

	def ft_flagindexbytoken(self, token):
		uid = GEEntity.GetUniqueId(token)
		rtn_j = -1
		for j in range(self.FLAGLIST_LIMIT) :
			if( self.flaglist[j].token_id == uid ) :
				rtn_j = j
				break
		return rtn_j

	def ft_flagindexbyplayer(self, player):
		uid = GEEntity.GetUniqueId(player)
		rtn_j = -1
		for j in range(self.FLAGLIST_LIMIT) :
			if( self.flaglist[j].player_id == uid ) :
				rtn_j = j
				break
		return rtn_j

	def ft_flagindexbyplayerprevious(self, player):
		uid = GEEntity.GetUniqueId(player)
		rtn_j = -1
		for j in range(self.FLAGLIST_LIMIT) :
			if( self.flaglist[j].player_previous == uid ) :
				rtn_j = j
				break
		return rtn_j

	def ft_flaglist_openslot(self):
		rtn_index = -1
		for j in range(self.FLAGLIST_LIMIT):
			if self.flaglist[j].token_id == 0:
				rtn_index = j
				break
		return rtn_index

	def ft_flagsdesired(self):
		if GEMPGameRules.IsTeamplay():
			fd = ep_least(ep_least(GEMPGameRules.GetTeam(GEGlobal.TEAM_MI6).GetNumPlayers(), GEMPGameRules.GetTeam(GEGlobal.TEAM_JANUS).GetNumPlayers()), self.FLAGLIST_LIMIT)
			fd = ep_clamp(fd, 1, fd - ep_greatest(0, int(GEUtil.GetCVarValue("ld_teamguardians"))))
		else:
			playersperflag = ep_greatest(1, int(GEUtil.GetCVarValue("ld_playersperflag")))
			fd = ep_least(int((GEMPGameRules.GetNumActivePlayers() + playersperflag - 1) / playersperflag ), self.FLAGLIST_LIMIT)
		return fd

	def ft_flagsregistered(self):
		flagsregistered = 0
		for j in range(self.FLAGLIST_LIMIT) :
			if self.flaglist[j].token_id != 0 :
				flagsregistered += 1
		return flagsregistered

	def ft_gameislive(self):
		return GEMPGameRules.GetNumActivePlayers() > 1 or FT_DEBUG

	def ft_omnomnomnom(self, player, itemname):
		flagindex = self.ft_flagindexbyplayer(player)
		if flagindex >= 0:
			quality = -1
			if itemname.startswith("item_armorvest_half"):
				quality = 2
			elif itemname.startswith("item_armorvest"):
				quality = 3
			elif itemname.startswith("weapon_"):
				quality = 1
			elif itemname.startswith("ge_ammo"):
				quality = 0
			if quality >= 0:
				if self.ft_gameislive():
					self.flaglist[flagindex].age_item(quality, 1.0)
#					ep_shout("Consumed %s for %d EXP." % (itemname, self.flaglist[flagindex].BONUS_ITEM[quality]))
		return True

	def ft_perk_speed(self, flagindex):
		if flagindex >= 0 and self.flaglist[flagindex].i_am_held():
			flag = self.flaglist[flagindex]
			player = ep_player_by_id(flag.player_id)
			perk = (1.0 + (float(GEMPGameRules.GetNumActivePlayers()) + (float(flag.adrenaline) * self.PERK_ADREN)) * self.PERK_SPEED) ** 0.5
			ep_shout("[Perk Speed] %f" % perk)
			player.SetSpeedMultiplier(ep_least(perk, ep_tf(GEMPGameRules.IsTeamplay(), 1.20, 1.35)))

	def ft_playercarries(self, player):
		return self.ft_flagindexbyplayer(player) != -1

	def ft_progressbar(self, flag, player):
		GEUtil.InitHudProgressBarPlayer(player, 0, "%d " % flag.earnings, 1, flag.exp_this_level(flag.level), -1, .76, self.BAR_CARRY, 10, self.COLOR_H_MI)
		#GEUtil.InitHudProgressBarPlayer(player, 0, "", 1, flag.exp_this_level(flag.level), -1, .76, self.BAR_CARRY, 10, self.COLOR_H_MI)
		#GEUtil.InitHudProgressBarPlayer(player, 2, "%d" % flag.earnings, 1, flag.exp_this_level(flag.level), self.BAR_CAP_X, .76, self.BAR_CARRY, 10, self.COLOR_H_MI)

	def ft_progressbar_remove(self, flag):
		GEUtil.RemoveHudProgressBarPlayer(ep_player_by_id(flag.player_id), 0)

	def ft_progressbars(self):
		for j in range(self.FLAGLIST_LIMIT) :
			flag = self.flaglist[j]
			if flag.player_id != 0 :
				GEUtil.UpdateHudProgressBarPlayer(ep_player_by_id(flag.player_id), 0, flag.exp_to_next)
			if flag.exp_to_escape > -1:
				GEUtil.UpdateHudProgressBarPlayer(ep_player_by_id(flag.player_id), 1, flag.exp_to_escape)

	def ft_progressbars_legacy(self):
		for j in range(self.FLAGLIST_LIMIT) :
			flag = self.flaglist[j]
			if flag.player_id != 0 :
				step = 4.0
#				text_lifespan = 0.1 * step
				text_lifespan = 0.2
#				if flag.exp_to_next % int(step) != 0:
#					return
				scale = 1.0 / step
				width = scale * flag.exp_this_level(flag.level)
				fill = scale * flag.exp_to_next
				exp_bar = ""
				for jj in range(1, int(width), 1):
					if jj < fill:
						exp_bar = "-%s" % exp_bar
					else:
						exp_bar = "!%s" % exp_bar
				exp_bar = "[%s] %d" % (exp_bar, flag.earnings)
				GEUtil.HudMessage(ep_player_by_id(flag.player_id), exp_bar, -1, .75, EP_SHOUT_COLOR,text_lifespan,0.0,0.0)
				
	def ft_registerflag(self, newflag_id):
		newflag_index = self.ft_flaglist_openslot()
		if( newflag_index > -1 ):
			self.flaglist[newflag_index].zot()
			self.flaglist[newflag_index].token_id = newflag_id
		else:
			ep_shout("[Register Flag] Failed to find an information slot. (CRITICAL)")
		return newflag_index

	def ft_shepherd(self):
		if self.ft_flagdebt() > 0 :
			GEMPGameRules.GetTokenMgr().SetTokenSpawnLimit(self.TokenClass, self.ft_flagsdesired())

	def ft_zot(self):
		GEMPGameRules.GetTokenMgr().SetTokenSpawnLimit(self.TokenClass, 0)
		for j in range(self.FLAGLIST_LIMIT) :
			self.flaglist[j].zot()

	def ft_zot_token(self, token):
		j = self.ft_flagindexbytoken(token)
		if j >= 0 :
			self.flaglist[j].zot()
		else:
			ep_shout("[Zot Token] Attempted to remove unregistered token %d" % GEEntity.GetUniqueId(token) )

	# Engine callbacks
	def __init__(self):
		super(TurboLD, self).__init__()
		self.TokenClass = 'token_deathmatch'
#		self.TokenGlow = GEUtil.CColor(11,198,244,240)
		self.TokenGlow = GEUtil.CColor(244, 192, 11, 64)

	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team TurboLD"
		return "TurboLD"
		
	def GetPrintName(self):
		return "TurboLD"
		
	def GetHelpString(self):
		return "#GES_GP_LD_HELP"
		
	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def ClientConnect(self, player):
		pass
		
	def ClientDisconnect(self, player):
		pass
		
	def OnThink(self):
		if self.ft_gameislive():
			self.ft_ageflags()
#		if FT_DEBUG:		
			self.ft_progressbars()
	
	def OnPlayerKilled(self, victim, killer, weapon):
		if victim == None:
			return
		#Disconnecting player_previous to prevent multiple penalties.
#		flagindex = self.ft_flagindexbyplayerprevious(victim)
#		if flagindex == -1:
		flagindex = self.ft_flagindexbyplayer(victim)
		if flagindex >= 0:
			self.flaglist[flagindex].player_previous = 0
		vid = GEEntity.GetUniqueId(victim)
		kid = GEEntity.GetUniqueId(killer)
		ep_shout("[OPK] Victim %d, Killer %d, VFlag Index %d" % (vid, kid, flagindex))
		bounty = ep_least(self.flaglist[flagindex].earnings, self.flaglist[flagindex].LEVEL_LIMIT)
		#Suicide TODO: Verify
		if killer == None or killer.GetIndex() == 0 or vid == kid or GEMPGameRules.IsTeamplay() and victim.GetTeamNumber() == killer.GetTeamNumber():
		#	suicide_bounty = int((bounty * 3 + 1) / 2)
			ep_incrementscore(victim, -ep_tf(flagindex >= 0, bounty + bounty, 1))
			return
		#slap and snatch TODO: Verify
#		GEUtil.HudMessage(None,"Killed with %s. Flag index: %d." % (weapon.GetClassname(), flagindex) ,-1,-1,EP_SHOUT_COLOR,2.0,0.25,2.75)
		if weapon != None and weapon.GetClassname() == "weapon_slappers" and flagindex >= 0:
#			delta = ep_tf(flagindex >= 0, ep_least(self.flaglist[flagindex].earnings_previous, self.flaglist[flagindex].LEVEL_LIMIT), 0)
			delta = ep_tf(flagindex >= 0, bounty, 0)
			if delta > 0:
				ep_incrementscore(victim, -delta)
				GEUtil.HudMessage(victim, "You lost %d point%s" % (delta, ep_plural(delta, ".", "s.")),-1,-1,EP_SHOUT_COLOR,2.0,0.25,2.75)
				ep_incrementscore(killer, delta)
				GEUtil.HudMessage(killer, "You stole %d point%s" % (delta, ep_plural(delta, ".", "s.")),-1,-1,EP_SHOUT_COLOR,2.0,0.25,2.75)
		#credit if token will be removed from play. TODO: Verify
		if self.ft_flagdebt() < 0:
			if flagindex >= 0:
				ep_incrementscore(killer, self.flaglist[flagindex].level)
			else:
				ep_shout("[OPK] No flag index associated with slain carrier whose flag is removed.")

	def OnPlayerSay(self, player, text):
		return False

	def OnLoadGamePlay(self):
		self.CreateCVar("ld_playersperflag", "4", "Number of players required to spawn a new flag.")
		self.CreateCVar("ld_teamguardians", "0", "Flags are withheld to ensure this many players must guard on the shortest team. One token will always be available.")
		tokenmgr = GEMPGameRules.GetTokenMgr()
		tokenmgr.AddTokenType(self.TokenClass, 1, GEGlobal.SPAWN_TOKEN)
		self.ft_zot()
		tokenmgr.SetTokenGlow(self.TokenClass, True, self.TokenGlow)
		tokenmgr.SetTokenAllowSwitch(self.TokenClass, False)
		tokenmgr.SetTokenRespawnDelay(self.TokenClass, 30 )
		tokenmgr.SetCustomTokenSettings( self.TokenClass, "models/weapons/tokens/v_flagtoken.mdl", "models/weapons/tokens/w_flagtoken.mdl", "Flag" )
		self.CreateCVar("ge_velocity", "1.5", "Velocity (speed) multiplier, range from 0.5 to 1.5.")
		
		GEMPGameRules.GetRadar().SetForceRadar(True)
		self.LoadConfig()
		GEUtil.PrecacheSound("GEGamePlay.Token_Chime")
		GEUtil.PrecacheSound("GEGamePlay.Token_Knock")
		GEUtil.PrecacheSound("Buttons.beep_ok")
		GEUtil.PrecacheSound("Buttons.beep_denied")

	def OnRoundBegin(self):
		self.ft_zot()
		GEMPGameRules.ResetAllPlayersScores()
		
	def OnRoundEnd(self):
		GEMPGameRules.GetRadar().DropAllContacts()
	
	def OnPlayerSpawn(self, player):
		player.SetSpeedMultiplier( float(GEUtil.GetCVarValue("ge_velocity")) )
		player.SetMaxArmor(int(GEGlobal.GE_MAX_ARMOR))
		player.GiveNamedWeapon("weapon_slappers", 0)
		self.ft_shepherd()

	def CanPickupEntity(self, player, entity):
# 		itemname = entity.GetClassname()
		# Suppress Armor ability.
		if self.ft_flagindexbyplayer(player) >= 0:
			player.SetMaxArmor(player.GetArmor())
		return self.ft_omnomnomnom(player, entity.GetClassname())
#		return not (itemname.startswith("item_armorvest") and self.ft_flagindexbyplayer(player) >= 0)

	def ShouldForcePickup(self, player, item):
		if self.ft_playercarries(player):
			GEUtil.PlaySoundToPlayer(player, "HL2Player.PickupWeapon")
			return True
		return False
	
	def CanPlayerHaveWeapon(self, player, weapon):
		return self.ft_omnomnomnom(player, weapon.GetClassname())
	
	def ShouldDoCustomDamage(self, victim, info, health, armour):
		if victim == None:
			return health, armour
		killer = GEPlayer.ToMPPlayer( info.GetAttacker() )
		v_flagindex = self.ft_flagindexbyplayer(victim)
		k_flagindex = self.ft_flagindexbyplayer(killer)
		#ep_shout("[SDCD] %d %d" % (v_flagindex, k_flagindex) )
		if v_flagindex >= 0:
			# Suicide or friendly fire exacerbates but does not trigger escape.
			total_damage = health + armour
			if killer == None or GEEntity.GetUniqueId(victim) == GEEntity.GetUniqueId(killer) or GEMPGameRules.IsTeamplay() and victim.GetTeamNumber() == killer.GetTeamNumber():
				self.flaglist[v_flagindex].escape(False, total_damage)
			else:
				self.flaglist[v_flagindex].escape(True, total_damage)
				self.ft_escapebar(self.flaglist[v_flagindex], victim)
		if k_flagindex >= 0:
			# Flag carrier steals a point on successful attack.
			ep_incrementscore(victim, -self.THEFT_DELTA)
			ep_incrementscore(killer, self.THEFT_DELTA)
			GEUtil.PlaySoundToPlayer(killer, "Buttons.beep_ok")
			GEUtil.PlaySoundToPlayer(victim, "Buttons.Token_Knock")
			ep_shout("Point stolen from %s via slap." % victim.GetPlayerName() )
		return health, armour

	def CalcFinalScores(self):
		pass
	
	def OnTokenSpawned(self, token):
		self.ft_registerflag(GEEntity.GetUniqueId(token))
		GEMPGameRules.GetRadar().AddRadarContact( token, GEGlobal.RADAR_TYPE_TOKEN, True, "", self.COLOR_COLD )
	
	def OnTokenPicked(self, token, player):
		GEMPGameRules.GetRadar().DropRadarContact( token )
		GEMPGameRules.GetRadar().AddRadarContact( player, GEGlobal.RADAR_TYPE_PLAYER, True, "sprites/hud/radar/run", ep_tf(GEMPGameRules.IsTeamplay(), ep_tf(player.GetTeamNumber() == GEGlobal.TEAM_MI6, self.COLOR_H_MI, self.COLOR_H_JS), self.COLOR_HOLD) )
		GEUtil.PlaySoundToPlayer(player, "GEGamePlay.Token_Grab")
		flagindex = self.ft_flagindexbytoken(token)
		if GEMPGameRules.IsTeamplay() and flagindex >= 0 and self.flaglist[flagindex].team_previous == player.GetTeamNumber() :
			self.ft_associate(token, player)
		else:
			self.ft_coldflaglevel(self.ft_associate(token, player))
		health_coefficient = 2.0 * float(player.GetHealth() + player.GetArmor()) / float(player.GetMaxHealth() + player.GetMaxArmor())
		player.SetHealth(player.GetMaxHealth())
		player.SetArmor(player.GetMaxArmor())
		self.flaglist[self.ft_flagindexbytoken(token)].age_item(3, health_coefficient)

	def OnTokenDropped(self, token, player):
		if self.ft_flagdebt() >= 0:
			GEMPGameRules.GetRadar().AddRadarContact( token, GEGlobal.RADAR_TYPE_TOKEN, True, "", self.COLOR_WARM )
			GEMPGameRules.GetRadar().DropRadarContact( player )
		#	GEUtil.PlaySoundToPlayer(player,"Buttons.beep_denied")
			self.ft_disassociate(token, False)
		else:
			GEMPGameRules.GetTokenMgr().RemoveTokenEnt(token)

	def OnTokenRemoved(self, token):
		self.ft_disassociate(token, True)
		GEMPGameRules.GetRadar().DropRadarContact( token )
		GEMPGameRules.GetRadar().DropRadarContact( token.GetOwner() )

	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == "ge_velocity":
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				player.SetSpeedMultiplier( float(newvalue) )